unit UColunasBD;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, ZedGraph, System.Globalization,
  Borland.Data.Provider;

type
  TFrmColunasBD = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    ZedGraphControl1: ZedGraph.ZedGraphControl;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TFrmColunasBD_Load(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TFrmColunasBD))]

implementation

uses UDM;

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFrmColunasBD.InitializeComponent;
begin
  Self.ZedGraphControl1 := ZedGraph.ZedGraphControl.Create;
  Self.SuspendLayout;
  // 
  // ZedGraphControl1
  // 
  Self.ZedGraphControl1.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top 
    or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left) 
    or System.Windows.Forms.AnchorStyles.Right)));
  Self.ZedGraphControl1.CultureInfo := System.Globalization.CultureInfo.Create('p' +
    't-BR');
  Self.ZedGraphControl1.IsAutoScrollRange := False;
  Self.ZedGraphControl1.IsEnableHPan := True;
  Self.ZedGraphControl1.IsEnableVPan := True;
  Self.ZedGraphControl1.IsEnableZoom := True;
  Self.ZedGraphControl1.IsScrollY2 := False;
  Self.ZedGraphControl1.IsShowContextMenu := True;
  Self.ZedGraphControl1.IsShowHScrollBar := False;
  Self.ZedGraphControl1.IsShowPointValues := False;
  Self.ZedGraphControl1.IsShowVScrollBar := False;
  Self.ZedGraphControl1.IsZoomOnMouseCenter := False;
  Self.ZedGraphControl1.Location := System.Drawing.Point.Create(8, 16);
  Self.ZedGraphControl1.Name := 'ZedGraphControl1';
  Self.ZedGraphControl1.PanButtons := System.Windows.Forms.MouseButtons.Left;
  Self.ZedGraphControl1.PanButtons2 := System.Windows.Forms.MouseButtons.Middle;
  Self.ZedGraphControl1.PanModifierKeys2 := System.Windows.Forms.Keys.None;
  Self.ZedGraphControl1.PointDateFormat := 'g';
  Self.ZedGraphControl1.PointValueFormat := 'G';
  Self.ZedGraphControl1.ScrollMaxX := 0;
  Self.ZedGraphControl1.ScrollMaxY := 0;
  Self.ZedGraphControl1.ScrollMaxY2 := 0;
  Self.ZedGraphControl1.ScrollMinX := 0;
  Self.ZedGraphControl1.ScrollMinY := 0;
  Self.ZedGraphControl1.ScrollMinY2 := 0;
  Self.ZedGraphControl1.Size := System.Drawing.Size.Create(608, 296);
  Self.ZedGraphControl1.TabIndex := 0;
  Self.ZedGraphControl1.ZoomButtons := System.Windows.Forms.MouseButtons.Left;
  Self.ZedGraphControl1.ZoomButtons2 := System.Windows.Forms.MouseButtons.None;
  Self.ZedGraphControl1.ZoomModifierKeys := System.Windows.Forms.Keys.None;
  Self.ZedGraphControl1.ZoomModifierKeys2 := System.Windows.Forms.Keys.None;
  Self.ZedGraphControl1.ZoomStepFraction := 0.100000001490116;
  // 
  // TFrmColunasBD
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(632, 326);
  Self.Controls.Add(Self.ZedGraphControl1);
  Self.Name := 'TFrmColunasBD';
  Self.ShowInTaskbar := False;
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := 'WinForm';
  Self.WindowState := System.Windows.Forms.FormWindowState.Maximized;
  Include(Self.Load, Self.TFrmColunasBD_Load);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TFrmColunasBD.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TFrmColunasBD.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TFrmColunasBD.TFrmColunasBD_Load(sender: System.Object; e: System.EventArgs);
var
  coluna: BarItem;
  area: array of Double;
  pais: array of String;
  //includa unit Borland.Data.Provider
  dr: BdpDataReader;
  i: integer;
  ItemTexto: TextItem;
  rotulo: string;

begin
  //j foi comentado em outro exemplo
  ZedGraphControl1.GraphPane.Title := 'Grfico de rea por Pas';
  ZedGraphControl1.GraphPane.XAxis.Title:= 'Pais';
  ZedGraphControl1.GraphPane.YAxis.Title:= 'rea (em Dezenas de Km)';

  {O componente BdpCommand  utilizado para executar instrues SQL.
  Com a funo ExecuteReader o BdpCommand
  executar uma instruo SELECT e retornar um BdpDataReader
  que ser utilizado para ler os dados retornados.
  Esta  uma classe utilizada somente para leitura de dados.}
  dm.bdpCommand1.Close;
  dm.bdpCommand1.CommandText:= 'select name, area from country';
  dr:= dm.bdpCommand1.ExecuteReader;

  //Enquanto no chegar no final dos dados do BdpDataReader, executa o cdigo.
  //A funo Read l uma linha do conjunto de dados e passa para a prxima.
  while dr.Read do
  begin
    //Aumenta o tamanho dos vetores dinamicamente, a cada passo do lao while.
    SetLength(area, i+1);
    SetLength(pais, i+1);

    //Pega a populao do pas do conjunto de dados e vai armazenando no vetor Populacao.
    area[i]:= System.Convert.ToDouble(dr['area'])  / 10000;
    //Pega o nome do pas  do conjunto de dados e vai armazenando no vetor Pais.
    pais[i]:= dr['name'].ToString;
    inc(i);
  end;
  dm.BdpCommand1.close;

  //j foi comentado em outro exemplo
  coluna := ZedGraphControl1.GraphPane.AddBar('rea', nil, area, Color.Red);
  coluna.Bar.Fill := Fill.create( Color.Red, Color.White, Color.Red );

  //j foi comentado em outro exemplo
  ZedGraphControl1.GraphPane.XAxis.TextLabels := pais;
  ZedGraphControl1.GraphPane.XAxis.&Type := AxisType.Text;
  {Define o ngulo do rtulo da Axi X, que, neste caso, mostra
  os nomes dos pases.}
  ZedGraphControl1.GraphPane.XAxis.ScaleFontSpec.Angle := 90 ;
  //Define o tamanho da fonte do rtulo da Axi X.
  ZedGraphControl1.GraphPane.XAxis.ScaleFontSpec.Size := 9;

  //j foi comentado em outro exemplo
  ZedGraphControl1.GraphPane.AxisFill := Fill.Create( Color.White, Color.LightBlue, 180 );
  ZedGraphControl1.GraphPane.PaneFill := Fill.Create( Color.White );
  ZedGraphControl1.GraphPane.YAxis.Step := 100;

  {O comentrio da linha abaixo cria uma regio no cdigo
  e esta acaba na linha $ENDREGION. Uma regio  utilizada
  no Delphi 2005 para tornar mais visvel parte do cdigo
  que tenha alguma finalidade especfica que merea
  ser destacada. Assim,  criado um sinal de -/+ para recolher
  a seo, ocultado seu contedo, ou expandir,
  mostrando seu contedo.}
  {$REGION 'Colocar valor em cima da coluna'}
  for i:=0 to high(pais) do
  begin
    //Formata o rotuloel para ter uma casa decimal.
    rotulo := area[i].ToString('F1');
    {Cria o item de texto a ser colocado no topo das colunas.}
    ItemTexto := TextItem.Create(rotulo, i+1, area[i] + 5);
    // tell Zedgraph to use user scale units for locating the TextItem
    ItemTexto.Location.CoordinateFrame := CoordType.AxisXYScale;
    //Alinha o texto, horizontalmente  esquerda.
    ItemTexto.Location.AlignH := AlignH.Left;
    //Alinha o texto, verticalmente no centro.
    ItemTexto.Location.AlignV := AlignV.Center;
    ItemTexto.FontSpec.Border.IsVisible := false;
    //Define o tamanho da fonte.
    ItemTexto.FontSpec.Size := 8;
    ItemTexto.FontSpec.Fill.IsVisible := false;
    //Define um ngulo de 45 graus para o texto.
    ItemTexto.FontSpec.Angle := 45;
    //Adiciona o texto ao grfico.
    ZedGraphControl1.GraphPane.GraphItemList.Add(ItemTexto);
  end;
  // Colocar as barras uma sobre as outras. Usado quando foram adicionadas mais de uma barra no grfico.
  //ZedGraphControl1.GraphPane.BarType := BarType.Overlay;
  {$ENDREGION}

  //j foi comentado em outro exemplo
  ZedGraphControl1.GraphPane.AxisChange(CreateGraphics);
end;

end.
